<!DOCTYPE html><html lang="fa" dir="rtl"><head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسهیلات وام آسان | تجربه بانکداری مدرن</title>
    <link rel="stylesheet" href="css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* Reset and Base Styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        :root {
            --primary: #2c5aa0;
            --primary-light: #3b7ddd;
            --secondary: #ffd700;
            --accent: #ff7e5f;
            --success: #2ecc71;
            --gradient: linear-gradient(135deg, #2c5aa0 0%, #1e3a8a 100%);
            --gradient-light: linear-gradient(135deg, #3b7ddd 0%, #2c5aa0 100%);
            --shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            --transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        
        body {
            font-family: 'Vazirmatn', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #333;
            line-height: 1.6;
            min-height: 100vh;
            padding: 0;
            overflow-x: hidden;
        }
        
        .container {
            max-width: 480px;
            margin: 0 auto;
            background: white;
            min-height: 100vh;
            box-shadow: 0 0 40px rgba(0, 0, 0, 0.2);
            position: relative;
            overflow-x: hidden;
        }
        
        /* Floating Background Elements */
        .floating-bg {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 0;
            overflow: hidden;
        }
        
        .floating-circle {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            animation: float 15s infinite linear;
        }
        
        .circle-1 {
            width: 120px;
            height: 120px;
            top: 10%;
            right: -30px;
            animation-duration: 20s;
        }
        
        .circle-2 {
            width: 80px;
            height: 80px;
            bottom: 20%;
            left: -20px;
            animation-duration: 25s;
            animation-direction: reverse;
        }
        
        .circle-3 {
            width: 60px;
            height: 60px;
            top: 40%;
            left: 10%;
            animation-duration: 18s;
        }
        
        .circle-4 {
            width: 100px;
            height: 100px;
            bottom: 10%;
            right: 20%;
            animation-duration: 22s;
            animation-direction: reverse;
        }
        
        .circle-5 {
            width: 70px;
            height: 70px;
            top: 15%;
            left: 15%;
            animation-duration: 17s;
        }
        
        @keyframes float {
            0% {
                transform: translate(0, 0) rotate(0deg);
            }
            25% {
                transform: translate(20px, 30px) rotate(90deg);
            }
            50% {
                transform: translate(0, 60px) rotate(180deg);
            }
            75% {
                transform: translate(-20px, 30px) rotate(270deg);
            }
            100% {
                transform: translate(0, 0) rotate(360deg);
            }
        }
        
        /* Particle Background */
        .particles {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
        }
        
        .particle {
            position: absolute;
            background: rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            animation: particle-float 20s infinite linear;
        }
        
        @keyframes particle-float {
            0% {
                transform: translateY(0) rotate(0deg);
                opacity: 0;
            }
            10% {
                opacity: 1;
            }
            90% {
                opacity: 1;
            }
            100% {
                transform: translateY(-100vh) rotate(360deg);
                opacity: 0;
            }
        }
        
        /* Header Styles */
        header {
            background: var(--gradient);
            color: white;
            padding: 25px 20px;
            text-align: center;
            position: relative;
            border-radius: 0 0 30px 30px;
            box-shadow: var(--shadow);
            z-index: 10;
            overflow: hidden;
        }

        header::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="none"><path d="M0,0 L100,0 L100,100 Z" fill="rgba(255,255,255,0.05)"/></svg>');
            background-size: cover;
        }
        
        .header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            animation: slideDown 0.8s ease-out;
            position: relative;
            z-index: 2;
        }
        
        .logo-container {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .logo-img {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, var(--secondary), #ffed4e);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
            animation: logoPulse 3s infinite;
            position: relative;
            overflow: hidden;
        }
        
        .logo-img::before {
            content: '';
            position: absolute;
            width: 100%;
            height: 100%;
            background: linear-gradient(45deg, transparent, rgba(255,255,255,0.3), transparent);
            transform: translateX(-100%);
            animation: shine 3s infinite;
        }
        
        .logo-img i {
            color: var(--primary);
            font-size: 1.2rem;
            z-index: 1;
        }
        
        .logo-text {
            font-size: 1.8rem;
            font-weight: 700;
            background: linear-gradient(45deg, var(--secondary), #ffed4e);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            text-shadow: 0 2px 10px rgba(255, 215, 0, 0.3);
            text-decoration: none;
            position: relative;
        }
        
        .logo-text::after {
            content: '';
            position: absolute;
            bottom: -5px;
            right: 0;
            width: 0;
            height: 2px;
            background: var(--secondary);
            transition: width 0.3s ease;
        }
        
        .logo-text:hover::after {
            width: 100%;
        }
        
        .notification-icon {
            font-size: 1.5rem;
            position: relative;
            animation: pulse 2s infinite;
            color: white;
            text-decoration: none;
            background: rgba(255, 255, 255, 0.1);
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: var(--transition);
        }
        
        .notification-icon:hover {
            transform: scale(1.1) rotate(10deg);
            background: rgba(255, 255, 255, 0.2);
        }
        
        .notification-icon::after {
            content: '';
            position: absolute;
            top: -5px;
            right: -5px;
            width: 12px;
            height: 12px;
            background: #ff4757;
            border-radius: 50%;
            border: 2px solid #1e3a8a;
            animation: pulse-red 1.5s infinite;
        }
        
        /* Main Content */
        .main-content {
            padding: 25px 20px;
            position: relative;
            z-index: 5;
        }
        
        .page-title {
            font-size: 1.5rem;
            color: var(--primary);
            margin-bottom: 25px;
            font-weight: 700;
            display: flex;
            align-items: center;
            animation: slideInRight 0.6s ease-out;
            position: relative;
        }
        
        .page-title i {
            margin-left: 10px;
            color: var(--primary);
            font-size: 1.6rem;
        }
        
        /* Loan Types Section */
        .loan-types {
            margin-bottom: 30px;
        }
        
        .loan-card {
            background: white;
            border-radius: 20px;
            padding: 25px;
            margin-bottom: 20px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(0, 0, 0, 0.03);
            animation: fadeInUp 0.6s ease-out;
            text-decoration: none;
            display: block;
            color: inherit;
        }
        
        .loan-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(59, 125, 221, 0.05) 0%, rgba(44, 90, 160, 0.05) 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .loan-card::after {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="none"><path d="M0,0 L100,0 L100,100 Z" fill="rgba(255,255,255,0.05)"/></svg>');
            background-size: cover;
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .loan-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
            color: inherit;
        }
        
        .loan-card:hover::before,
        .loan-card:hover::after {
            opacity: 1;
        }
        
        .loan-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            position: relative;
            z-index: 2;
        }
        
        .loan-title {
            font-size: 1.3rem;
            font-weight: 700;
            color: var(--primary);
        }
        
        .loan-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            background: var(--gradient-light);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.4rem;
            color: white;
            box-shadow: 0 5px 15px rgba(59, 125, 221, 0.4);
            transition: var(--transition);
        }
        
        .loan-card:hover .loan-icon {
            transform: scale(1.1) rotate(5deg);
        }
        
        .loan-details {
            margin-bottom: 20px;
            position: relative;
            z-index: 2;
        }
        
        .loan-feature {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
            font-size: 0.95rem;
            color: #555;
        }
        
        .loan-feature i {
            margin-left: 10px;
            color: var(--success);
            font-size: 1rem;
        }
        
        .loan-amount {
            background: var(--gradient-light);
            color: white;
            padding: 12px 15px;
            border-radius: 12px;
            text-align: center;
            font-weight: 700;
            font-size: 1.1rem;
            box-shadow: 0 5px 15px rgba(59, 125, 221, 0.3);
            position: relative;
            z-index: 2;
            transition: var(--transition);
        }
        
        .loan-card:hover .loan-amount {
            transform: scale(1.05);
        }
        
        /* Loan Benefits Section */
        .loan-benefits {
            margin-bottom: 30px;
        }
        
        .benefits-title {
            font-size: 1.2rem;
            color: var(--primary);
            margin-bottom: 18px;
            font-weight: 600;
            display: flex;
            align-items: center;
            animation: slideInRight 0.6s ease-out;
            position: relative;
        }
        
        .benefits-title i {
            margin-left: 10px;
            color: var(--primary);
            font-size: 1.3rem;
        }
        
        .benefits-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
        }
        
        .benefit-item {
            background: white;
            border-radius: 15px;
            padding: 20px 15px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .benefit-item:hover {
            transform: translateY(-5px);
        }
        
        .benefit-icon {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: var(--gradient-light);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 10px;
            font-size: 1.3rem;
            color: white;
            box-shadow: 0 5px 15px rgba(59, 125, 221, 0.4);
        }
        
        .benefit-title {
            font-size: 0.9rem;
            font-weight: 600;
            color: #444;
        }
        
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            right: 0;
            left: 0;
            max-width: 480px;
            margin: 0 auto;
            background: white;
            display: flex;
            justify-content: space-around;
            padding: 15px 0;
            box-shadow: 0 -5px 20px rgba(0, 0, 0, 0.1);
            border-radius: 25px 25px 0 0;
            z-index: 100;
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.95);
        }
        
        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: #777;
            font-size: 0.8rem;
            transition: var(--transition);
            position: relative;
            padding: 5px 10px;
            border-radius: 15px;
        }
        
        .nav-item.active {
            color: var(--primary);
            background: rgba(59, 125, 221, 0.1);
        }
        
        .nav-item.active::before {
            content: '';
            position: absolute;
            top: -5px;
            width: 30px;
            height: 3px;
            background: var(--primary);
            border-radius: 3px;
        }
        
        .nav-icon {
            font-size: 1.4rem;
            margin-bottom: 5px;
            transition: var(--transition);
        }
        
        .nav-item.active .nav-icon {
            transform: translateY(-5px);
        }
        
        .nav-item:hover {
            color: var(--primary);
            transform: translateY(-3px);
        }
        
        /* Animation Keyframes */
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes pulse {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.1);
            }
            100% {
                transform: scale(1);
            }
        }
        
        @keyframes pulse-red {
            0% {
                box-shadow: 0 0 0 0 rgba(255, 71, 87, 0.7);
            }
            70% {
                box-shadow: 0 0 0 10px rgba(255, 71, 87, 0);
            }
            100% {
                box-shadow: 0 0 0 0 rgba(255, 71, 87, 0);
            }
        }
        
        @keyframes logoPulse {
            0%, 100% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
        }
        
        @keyframes shine {
            0% {
                transform: translateX(-100%);
            }
            20% {
                transform: translateX(100%);
            }
            100% {
                transform: translateX(100%);
            }
        }
        
        @keyframes particle-float {
            0% {
                transform: translateY(0) rotate(0deg);
                opacity: 0;
            }
            10% {
                opacity: 1;
            }
            90% {
                opacity: 1;
            }
            100% {
                transform: translateY(-100vh) rotate(360deg);
                opacity: 0;
            }
        }
        
        /* Responsive Adjustments */
        @media (max-width: 480px) {
            .container {
                border-radius: 0;
            }
            
            header {
                border-radius: 0;
            }
            
            .bottom-nav {
                border-radius: 0;
            }
            
            .benefits-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="floating-bg">
        <div class="floating-circle circle-1"></div>
        <div class="floating-circle circle-2"></div>
        <div class="floating-circle circle-3"></div>
        <div class="floating-circle circle-4"></div>
        <div class="floating-circle circle-5"></div>
    </div>
    
    <div class="particles" id="particles"></div>
    
    <div class="container">
        <!-- Header -->
        <header>
            <div class="header-content">
                <div class="logo-container">
                    <div class="logo-img">
                        <i class="fas fa-crown"></i>
                    </div>
                    <a href="/dashboard" class="logo-text">وام آسان</a>
                </div>
        <!--        <a href="/notifications" class="notification-icon">
                    <i class="far fa-bell"></i>
                </a> -->
            </div>
        </header>
        
        <!-- Main Content -->
        <div class="main-content">
            <!-- Page Title -->
            <div class="page-title">
                <i class="fas fa-hand-holding-usd"></i>
                <span>تسهیلات وام آسان</span>
            </div>
            
            <!-- Loan Types Section -->
            <div class="loan-types">
                <!-- تسهیلات پشتوانه -->
                <a href="loan1" class="loan-card">
                    <div class="loan-header">
                        <div class="loan-title">تسهیلات پشتوانه</div>
                        <div class="loan-icon">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                    </div>
                    <div class="loan-details">
                        <div class="loan-feature">
                            <i class="fas fa-check-circle"></i>
                            <span>بدون ضامن و وثیقه</span>
                        </div>
                    </div>
                    <div class="loan-amount">
                        ۱۰ تا ۵۰ میلیون تومان
                    </div>
                </a>
                
                <!-- تسهیلات برآیند -->
                <a href="loan2" class="loan-card">
                    <div class="loan-header">
                        <div class="loan-title">تسهیلات برآیند</div>
                        <div class="loan-icon">
                            <i class="fas fa-coins"></i>
                        </div>
                    </div>
                    <div class="loan-details">
                        <div class="loan-feature">
                            <i class="fas fa-check-circle"></i>
                            <span>بر اساس موجودی حساب بانکی</span>
                        </div>
                    </div>
                    <div class="loan-amount">
                        ۵۰ تا ۱۰۰‌ میلیون تومان
                    </div>
                </a>
                
                <!-- تسهیلات بیمان -->
                <a href="loan3" class="loan-card">
                    <div class="loan-header">
                        <div class="loan-title">تسهیلات بیمان</div>
                        <div class="loan-icon">
                            <i class="fas fa-home"></i>
                        </div>
                    </div>
                    <div class="loan-details">
                        <div class="loan-feature">
                            <i class="fas fa-check-circle"></i>
                            <span>بدونه وثیقه</span>
                        </div>
                    </div>
                    <div class="loan-amount">
                        ۱۰۰ تا ۲۰۰ میلیون تومان
                    </div>
                </a>
                
                <!-- تسهیلات برآیند چگبار -->
                <a href="loan4" class="loan-card">
                    <div class="loan-header">
                        <div class="loan-title">تسهیلات برآیند چگبار</div>
                        <div class="loan-icon">
                            <i class="fas fa-chart-line"></i>
                        </div>
                    </div>
                    <div class="loan-details">
                        <div class="loan-feature">
                            <i class="fas fa-check-circle"></i>
                            <span>واریز بعد ۲۴ ساعت</span>
                        </div>
                    </div>
                    <div class="loan-amount">
                        ۲۰۰ تا ۳۰۰ میلیون تومان
                    </div>
                </a>
            </div>
            
            <!-- Loan Benefits Section -->
            <div class="loan-benefits">
                <div class="benefits-title">
                    <i class="fas fa-star"></i>
                    <span>مزایای تسهیلات وام آسان</span>
                </div>
                
                <div class="benefits-grid">
                    <div class="benefit-item">
                        <div class="benefit-icon">
                            <i class="fas fa-bolt"></i>
                        </div>
                        <div class="benefit-title">پرداخت سریع</div>
                    </div>
                    
                    <div class="benefit-item">
                        <div class="benefit-icon">
                            <i class="fas fa-percentage"></i>
                        </div>
                        <div class="benefit-title">سود رقابتی</div>
                    </div>
                    
                    <div class="benefit-item">
                        <div class="benefit-icon">
                            <i class="fas fa-file-alt"></i>
                        </div>
                        <div class="benefit-title">مدارک ساده</div>
                    </div>
                    
                    <div class="benefit-item">
                        <div class="benefit-icon">
                            <i class="fas fa-headset"></i>
                        </div>
                        <div class="benefit-title">پشتیبانی ۲۴/۷</div>
                    </div>
                </div>
            </div>
        </div>
        
   
        <nav class="bottom-nav">
      <!--      <a href="../" class="nav-item">
                <div class="nav-icon">
                    <i class="fas fa-home"></i>
                </div>
                <div>صفحه اصلی</div>
            </a> -->
            
   <!--         <a href="/services" class="nav-item">
                <div class="nav-icon">
                    <i class="fas fa-th-large"></i>
                </div>
                <div>خدمات</div>
            </a>
            -->
            <a href="loans" class="nav-item active">
                <div class="nav-icon">
                    <i class="fas fa-hand-holding-usd"></i>
                </div>
                <div>تسهیلات</div>
            </a>
            
            <a href="status" class="nav-item">
                <div class="nav-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div>استعلام وضعیت</div>
            </a>
        </nav>
    </div>

    <script>
        // ایجاد ذرات متحرک در پس‌زمینه
        function createParticles() {
            const particlesContainer = document.getElementById('particles');
            const particleCount = 30;
            
            for (let i = 0; i < particleCount; i++) {
                const particle = document.createElement('div');
                particle.classList.add('particle');
                
                // اندازه تصادفی
                const size = Math.random() * 5 + 2;
                particle.style.width = `${size}px`;
                particle.style.height = `${size}px`;
                
                // موقعیت تصادفی
                particle.style.left = `${Math.random() * 100}%`;
                particle.style.top = `${Math.random() * 100}%`;
                
                // تاخیر تصادفی در شروع انیمیشن
                particle.style.animationDelay = `${Math.random() * 20}s`;
                
                // مدت زمان تصادفی برای انیمیشن
                particle.style.animationDuration = `${Math.random() * 10 + 15}s`;
                
                particlesContainer.appendChild(particle);
            }
        }
        
        // افزودن انیمیشن‌های تعاملی
        document.addEventListener('DOMContentLoaded', function() {
            // ایجاد ذرات
            createParticles();
            
            // افزودن افکت کلیک برای کارت‌های تسهیلات
            const loanCards = document.querySelectorAll('.loan-card');
            loanCards.forEach(card => {
                card.addEventListener('click', function(e) {
                    // ایجاد افکت موج
                    const wave = document.createElement('div');
                    wave.style.position = 'absolute';
                    wave.style.borderRadius = '50%';
                    wave.style.background = 'rgba(59, 125, 221, 0.2)';
                    wave.style.transform = 'scale(0)';
                    wave.style.animation = 'wave 0.5s linear';
                    wave.style.pointerEvents = 'none';
                    
                    const rect = this.getBoundingClientRect();
                    const size = Math.max(rect.width, rect.height);
                    wave.style.width = size + 'px';
                    wave.style.height = size + 'px';
                    wave.style.left = (rect.width - size) / 2 + 'px';
                    wave.style.top = (rect.height - size) / 2 + 'px';
                    
                    this.style.position = 'relative';
                    this.appendChild(wave);
                    
                    // حذف المان موج پس از انیمیشن
                    setTimeout(() => {
                        if (this.contains(wave)) {
                            this.removeChild(wave);
                        }
                    }, 500);
                });
            });
            
            // افزودن استایل برای انیمیشن موج
            const style = document.createElement('style');
            style.textContent = `
                @keyframes wave {
                    to {
                        transform: scale(2);
                        opacity: 0;
                    }
                }
            `;
            document.head.appendChild(style);
        });
    </script>

</body></html>
//CODED BY @MD0TM