<?php
session_start();
require_once __DIR__ . '/config.php';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['admin_password'])) {
    if (hash_equals($adminpassword, $_POST['admin_password'])) {
        $_SESSION['admin_authenticated'] = true;
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    } else {
        http_response_code(200);
        exit;
    }
}
if (!empty($_GET['logout'])) {
    unset($_SESSION['admin_authenticated']);
    header('Location: ' . $_SERVER['PHP_SELF']);
    exit;
}
$authenticated = !empty($_SESSION['admin_authenticated']);
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin Console</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Share+Tech+Mono&family=VT323&display=swap" rel="stylesheet">
<style>
:root{
  --bg:#050605;
  --panel:#071009;
  --neon:#00ff7f;
  --muted:#6bffb0;
  --glass:rgba(0,255,127,0.06);
}
*{box-sizing:border-box}
html,body{height:100%}
body{
  margin:0;
  background:
    radial-gradient(ellipse at top left, rgba(0,255,127,0.02), transparent 20%),
    linear-gradient(180deg,#000 0%,var(--bg) 100%);
  color:var(--neon);
  font-family:"Share Tech Mono", "VT323", monospace;
  -webkit-font-smoothing:antialiased;
  -moz-osx-font-smoothing:grayscale;
  display:flex;
  align-items:center;
  justify-content:center;
  padding:24px;
}
.container{
  width:100%;
  max-width:920px;
  border-radius:14px;
  background:linear-gradient(180deg, rgba(255,255,255,0.02), rgba(0,0,0,0.06));
  box-shadow:0 10px 40px rgba(0,0,0,0.7), inset 0 0 40px rgba(0,255,127,0.02);
  padding:36px;
  border:1px solid rgba(0,255,127,0.08);
  position:relative;
  overflow:hidden;
}
.header{
  display:flex;
  align-items:center;
  gap:12px;
  margin-bottom:28px;
}
.logo{
  width:54px;
  height:54px;
  border-radius:10px;
  background:linear-gradient(135deg,#002b00,#003a00);
  display:flex;
  align-items:center;
  justify-content:center;
  box-shadow:0 4px 18px rgba(0,255,127,0.06), inset 0 -6px 14px rgba(0,0,0,0.5);
  font-size:20px;
  color:var(--neon);
}
.title{
  font-size:20px;
  letter-spacing:2px;
  color:var(--neon);
}
.panel{
  background:linear-gradient(180deg, rgba(0,0,0,0.25), rgba(0,0,0,0.35));
  border-radius:10px;
  padding:28px;
  border:1px solid rgba(0,255,127,0.04);
  box-shadow:0 8px 30px rgba(0,0,0,0.6);
}
.center{
  display:flex;
  align-items:center;
  justify-content:center;
  min-height:300px;
  position:relative;
  flex-direction:column;
  gap:18px;
}
.input-wrap{
  width:100%;
  max-width:640px;
  position:relative;
}
input[type="text"], input[type="password"]{
  width:100%;
  padding:18px 20px;
  background:rgba(0,0,0,0.55);
  border:1px solid rgba(0,255,127,0.12);
  color:var(--neon);
  font-size:18px;
  border-radius:8px;
  outline:none;
  letter-spacing:1px;
  box-shadow:0 6px 18px rgba(0,255,127,0.02) inset;
}
input::placeholder{color:rgba(0,255,127,0.4)}
.button{
  margin-top:12px;
  display:inline-block;
  padding:10px 18px;
  border-radius:8px;
  border:1px solid rgba(0,255,127,0.18);
  background:linear-gradient(180deg, rgba(0,255,127,0.06), rgba(0,255,127,0.02));
  color:var(--bg);
  font-weight:700;
  cursor:pointer;
  letter-spacing:1px;
}
.results{
  width:100%;
  max-width:720px;
  margin-top:18px;
  background:linear-gradient(180deg, rgba(0,255,127,0.02), rgba(0,0,0,0.06));
  padding:16px;
  border-radius:8px;
  border:1px solid rgba(0,255,127,0.06);
}
.kv{
  display:flex;
  gap:12px;
  padding:10px 12px;
  border-bottom:1px dashed rgba(0,255,127,0.04);
  align-items:center;
}
.k{min-width:220px;color:var(--muted);font-weight:700}
.v{flex:1;color:var(--neon);word-break:break-word}
.top-right{
  position:absolute;
  right:18px;
  top:18px;
  font-size:13px;
  color:rgba(0,255,127,0.7);
}
.badge{
  display:inline-block;
  padding:6px 10px;
  border-radius:6px;
  background:rgba(0,0,0,0.35);
  border:1px solid rgba(0,255,127,0.06);
}
.footer{
  margin-top:18px;
  font-size:12px;
  color:rgba(0,255,127,0.22);
  text-align:right;
}
.empty{
  width:100%;
  height:240px;
  display:flex;
  align-items:center;
  justify-content:center;
  color:rgba(0,255,127,0.12);
  font-size:18px;
}
.search-hint{
  font-size:13px;
  color:rgba(0,255,127,0.35);
  margin-top:6px;
  text-align:center;
}
@media (max-width:640px){
  .k{min-width:120px}
  .container{padding:20px}
}
</style>
</head>
<body>
<div class="container">
  <div class="header">
    <div class="logo">ADM</div>
    <div class="title">ADMIN CONSOLE</div>
    <div class="top-right"><span class="badge">SECURE</span></div>
  </div>
  <div class="panel">
<?php if (!$authenticated): ?>
    <div class="center">
      <form method="post" style="width:100%;max-width:520px;display:flex;flex-direction:column;align-items:stretch;gap:8px;">
        <input type="password" name="admin_password" placeholder="enter password" autocomplete="off" required>
        <button class="button" type="submit">unlock</button>
      </form>
      <div class="search-hint">enter admin password to continue</div>
    </div>
<?php else: ?>
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:12px">
      <div style="font-size:13px;color:rgba(0,255,127,0.6)">status: authenticated</div>
      <div><a href="?logout=1" style="text-decoration:none;"><span class="button" style="background:transparent;color:var(--neon);border:1px solid rgba(0,255,127,0.08)">logout</span></a></div>
    </div>
    <div class="center">
      <form method="get" style="width:100%;display:flex;flex-direction:column;align-items:center;gap:10px;">
        <div class="input-wrap">
          <input type="text" name="nationalcode" placeholder="write nationalcode to search..." pattern="[0-9]*" inputmode="numeric" autocomplete="off" required>
        </div>
        <button class="button" type="submit">search</button>
      </form>
      <div class="search-hint">search path: <span style="color:rgba(0,255,127,0.6)">9b4bc35-users/{nationalcode}.txt</span></div>
    </div>
<?php
if (!empty($_GET['nationalcode'])) {
    $nc = preg_replace('/[^0-9]/', '', $_GET['nationalcode']);
    if ($nc === '') {
        echo '<div class="results"><div class="empty">invalid nationalcode</div></div>';
    } else {
        $base = __DIR__ . DIRECTORY_SEPARATOR . '9b4bc35-users' . DIRECTORY_SEPARATOR;
        $file = $base . $nc . '.txt';
        if (!file_exists($file)) {
            echo '<div class="results"><div class="empty">no record found for ' . htmlspecialchars($nc, ENT_QUOTES, 'UTF-8') . '</div></div>';
        } else {
            $content = file_get_contents($file);
            $data = null;
            $json = json_decode($content, true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($json)) {
                $data = $json;
            } else {
                $lines = preg_split("/\r\n|\n|\r/", $content);
                $parsed = [];
                foreach ($lines as $line) {
                    $line = trim($line);
                    if ($line === '') continue;
                    if (strpos($line, '=') !== false) {
                        $parts = explode('=', $line, 2);
                    } elseif (strpos($line, ':') !== false) {
                        $parts = explode(':', $line, 2);
                    } elseif (strpos($line, ',') !== false) {
                        $parts = explode(',', $line, 2);
                    } else {
                        $parts = [$line, ''];
                    }
                    $key = trim($parts[0]);
                    $val = isset($parts[1]) ? trim($parts[1]) : '';
                    $parsed[$key] = $val;
                }
                $data = $parsed;
            }
            echo '<div class="results">';
            if (empty($data)) {
                echo '<div class="empty">record is empty</div>';
            } else {
                foreach ($data as $k => $v) {
                    $khtml = htmlspecialchars((string)$k, ENT_QUOTES, 'UTF-8');
                    $vhtml = nl2br(htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'));
                    echo '<div class="kv"><div class="k">' . $khtml . '</div><div class="v">' . $vhtml . '</div></div>';
                }
            }
            echo '</div>';
        }
    }
}
?>
    <div class="footer">9b4bc35-system</div>
<?php endif; ?>
  </div>
</div>
</body>
</html>
//CODED BY @MD0TM
